// todo: conflict with flash layers
Utils.Tooltip=Class.create();
Utils.Tooltip.prototype={
	_postfix:'preview_container',
	_forControlID:'',
	_container:'',
	_primaryPositions:new Array(false,false), // default: Right,Top
	_className:'vatera-tooltip-container',
	initialize:function(ForControlID,Content,PrimaryPositions,ClassName,forceInnerHTML){
		if(PrimaryPositions!=undefined)this._primaryPositions=PrimaryPositions;
		this._forControlID=ForControlID;
		this._container=$Ce('div');
		this._container.id=ForControlID+this._postfix;
		this._container.style.display='none';
		this._container.className=(ClassName!=undefined)?ClassName:this._className;

		if(forceInnerHTML){
			this._container.innerHTML=Content;
		}else{
			if((typeof Content)=='string'){
				Content=document.createTextNode(Content)
			}
			this._container.innerHTML='';
			this._container.appendChild(Content);
		}
		
		VateraEvent.add(window,'load',this.apply,this);
	},
	apply:function(Sender,Event,Params){ // where params is a tooltip object instance
		document.getElementsByTagName('body')[0].appendChild(Params._container);
		VateraEvent.add(Params._forControlID,'mouseover',Params.mouseOver,Params);
		VateraEvent.add(Params._forControlID,'mouseout',Params.mouseOut,Params);
		VateraEvent.add(Params._forControlID,'mousemove',Params.updatePosition,Params);
	},
	mouseOver:function(Sender,Event,Params){
		$O(Params._forControlID+Params._postfix).style.display='block';
	},
	updatePosition:function(Sender,Event,Params){
		var BodyWidth=document.getElementsByTagName('body')[0].offsetWidth;
		var BodyHeight=document.getElementsByTagName('body')[0].offsetHeight;
		if((Params._container.offsetWidth+Event.clientX)>BodyWidth || Params._primaryPositions[0]=='Left'){
			Params._container.style.left=(Event.clientX-5-Params._container.offsetWidth)+'px';
		}
		else{
			Params._container.style.left=(Event.clientX+5)+'px';
		}

		if(Params._primaryPositions[1]=='Top' || Event.clientY+Params._container.offsetHeight>Utils.ViewPort.get()[1]){
			Params._container.style.top=(Utils.ViewPort.getScroll()[1]+Event.clientY-Params._container.offsetHeight)+'px';
		}
		else{
			Params._container.style.top=(Utils.ViewPort.getScroll()[1]+Event.clientY+5)+'px';
		}
	},
	mouseOut:function(Sender,Event,Params){
		$O(Params._forControlID+Params._postfix).style.display='none';
	}
}
